#version 120

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform vec4 entityColor;

varying vec4 color;
varying vec4 texcoord;
varying vec4 lmcoord;

void main() {
	if(entityColor.r == 0)
	{
		gl_FragData[0] = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;
	}
	else
	{
		gl_FragData[0] = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color * entityColor;
	}
	gl_FragData[1] = vec4(vec3(gl_FragCoord.z), 1.0);
}
